import matplotlib.pyplot as plt
import matplotlib.patches as patches

# Create a figure and axis
fig, ax = plt.subplots(figsize=(8, 10))

# Define colors
clear_tile_color = 'lightgreen'
occupied_tile_color = 'lightcoral'
robot1_color = 'white'
robot2_color = 'black'
text_color_black = 'black'
text_color_white = 'white'

# Define grid size
rows, cols = 5, 4
tile_size = 1

# Draw tiles
for row in range(rows):
    for col in range(cols):
        tile_id = f'tile_{row}-{col+1}'
        if (row == 1 and col in [0, 1]):
            color = occupied_tile_color
        else:
            color = clear_tile_color
        rect = patches.Rectangle((col * tile_size, row * tile_size), tile_size, tile_size,
                                 linewidth=1, edgecolor='black', facecolor=color)
        ax.add_patch(rect)
        ax.text(col * tile_size + tile_size / 2, row * tile_size + tile_size / 2, tile_id,
                color=text_color_black, ha='center', va='center', fontsize=8)

# Draw robots
robot1 = patches.Circle((0.5 * tile_size, 1.5 * tile_size), 0.3, color=robot1_color, ec='black')
ax.add_patch(robot1)
ax.text(0.5 * tile_size, 1.5 * tile_size, 'robot1\nwhite', color=text_color_black, ha='center', va='center', fontsize=6)

robot2 = patches.Circle((1.5 * tile_size, 1.5 * tile_size), 0.3, color=robot2_color, ec='black')
ax.add_patch(robot2)
ax.text(1.5 * tile_size, 1.5 * tile_size, 'robot2\nblack', color=text_color_white, ha='center', va='center', fontsize=6)

# Set limits and remove axes
ax.set_xlim(0, cols * tile_size)
ax.set_ylim(0, rows * tile_size)
ax.set_aspect('equal')
ax.axis('off')

# Add legend
legend_labels = ['Clear Tile', 'Occupied Tile', 'Robot1 (White)', 'Robot2 (Black)']
legend_colors = [clear_tile_color, occupied_tile_color, robot1_color, robot2_color]
legend_patches = [patches.Patch(color=lc, label=ll) for lc, ll in zip(legend_colors, legend_labels)]
ax.legend(handles=legend_patches, loc='upper left', bbox_to_anchor=(1.05, 1), fontsize=8)

# Save the figure
plt.savefig('tiles/one_shot/ini_diagram_code/attempts/attempt_30.png', bbox_inches='tight')
plt.show()
# VERIFICATION FAILED:
# Robot actions are mislabeled in the diagram (e.g., "up" instead of "right" or "left").
